function bench = benchmarks(variable, SPF, hist, bench_label)

% compute benchmark forecasts for each survey deadline

% INPUT
% variable:         variable name
% SPF:              SPF forecast for the variable (structure)
% hist:             Historical realisation of the variable (structure)
% bench_label:      Labels of benchmarks

%OUTPUT
%bench:             Benchmark forecasts

%% indicator for monthly or quarterly variable

switch variable
    case 'GDP'
        f = 1; % observations per quarter
    case 'UN'
        f = 3;
    case 'HICP'
        f = 3;
end

%% compute the benchmark forecasts

% initialise bench_for (T,B,H,n_bench)
bench = NaN(size(SPF.data,1), size(SPF.data,2),2,size(bench_label,1));

for d=1:size(SPF.deadlines)

    %% historical data as available at the survey deadline
    ind_v = find (hist.vintages<=SPF.deadlines(d),1,'last');
    ind_end = find (hist.dates_realised<=SPF.deadlines(d),1,'last');
    if isempty(ind_v) % before the first vintage we need to add a pubblication delay      
        data = hist.data(1:ind_end-2*(f==1)-3*(f==3),1);
    else
        data = hist.data(:,ind_v);
    end
    dates_realised = hist.dates_realised(~isnan(data));
    data = data(~isnan(data));

    %% bins provided at the survey deadline
    bins_ind = ~isnan(SPF.edges(d, :));
    bins = SPF.edges(d, bins_ind);
    
    %% compute the benchmarks
    
    for b=1:size(bench_label,1)

        switch bench_label{b}

            case 'Uni' 

                bench(d,1:length(bins)-1,[1 2],b) = 0;

                i = find(bins<=min(data),1,'last');
                j = find(bins>=max(data),1,'first');
                bench(d,i:j-1,[1 2],b) = 1/(j-i);
            
            case 'UG'

                temp = diff(normcdf(SPF.edges(d, bins_ind), mean(data), std(data)));
                bench(d,1:length(temp),[1 2],b) = repmat(temp,1,1,2);
        
            case 'GRW'

                temp = diff(normcdf(SPF.edges(d, bins_ind), data(end), std(data)));
                bench(d,1:length(temp),[1 2],b) = repmat(temp,1,1,2);

            case 'GRWD'

                coef = [mean(diff(data)), 1];

                Y = data;

                for i = 1 : 24
                    F(i) = [1 Y(end)] * coef';
                    Y = [Y;F(i)];
                end

                temp = diff(normcdf(SPF.edges(d, bins_ind), Y(length(data)+12*(f==3)+4*(f==1)), std(data)));
                bench(d,1:length(temp),1,b) = temp;

                temp = diff(normcdf(SPF.edges(d, bins_ind), Y(length(data)+24*(f==3)+8*(f==1)), std(data)));
                bench(d,1:length(temp),2,b) = temp;

            case 'Naive'

                bench(d,:,[1 2],b) = SPF.naive(d,:,:); 
        end
    end
end
end